-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then 
    self.initialized = true
    self.counted = false
    self.unitsCounter = 0
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.deactivate = false  
      self.counted = false
      self.unitsCounter = 0
    end

    self.castleCond:LinkToTarget("changeOwner")  
    self.castleCond:LinkToTarget("handlerActivate")
	self.castleCond:LinkToTarget("victory")
  end
  
  if self.deactivate then
    return
  end
  
  if self.counted and self.unitsCounter == 0 then
    self.p0:WinQuest('D1G_GOAL_1')
    self.p0:AddQuest('D1G_GOAL_2','main')
    self.castleCond:TriggerAllTargets()
    self.deactivate = true
  end   
end

function OnTrigger(self, source, target)
  if target == "unitInitialized" then
    self.unitsCounter = self.unitsCounter + 1
    self.counted = true
  elseif target == "unitKilled" then
    self.unitsCounter = self.unitsCounter - 1
  end  
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
	  CreateTriggerSources(self)
	  self.deactivate = ar:Read()
    self.counted = ar:Read()
    self.unitsCounter = ar:Read()
  elseif (ar:IsSaving()) then
	  ar:Write(self.deactivate)
    ar:Write(self.counted)
    ar:Write(self.unitsCounter)
  end  
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("unitInitialized")
  self:AddTriggerTarget("unitKilled")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("castleCond")
end
